<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Agendamento;
use App\Models\DocumentoPessoa;
use App\Models\User;
use App\Repositories\Contracts\AgendamentoRepositoryInterface;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator as FacadesValidator;

class AgendamentoController extends Controller
{
    private $route = 'agendamentos';
    private $paginate = 10;
    private $search = ['detentor', 'municipio'];
    private $model;

    public function __construct(AgendamentoRepositoryInterface $model)
    {
        $this->model = $model;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $columnList = ['id' => '#', 'municipio' => trans('agendamento.municipio'), 'detentor' => trans('agendamento.name'),
            'cpf' => trans('agendamento.cpf'), 'titulo' => trans('agendamento.titulo'), 'nome_mae' => trans('agendamento.nome_mae'),
            'data' => trans('agendamento.data'), 'hora' => trans('agendamento.hora'), 'escritorio' => trans('agendamento.escritorio')];

        $page = trans('agendamento.agendamento_list');

        $search = "";
        if (isset($request->search)) {
            $search = $request->search;
            $list = $this->model->findWhereLike($this->search, $search, 'id', 'DESC');
        } else {
            $list = $this->model->paginate($this->paginate);
        }

        $routeName = $this->route;

        $breadcrumb = [
            (object) ['url' => route('home'), 'title' => trans('agendamento.home')],
            (object) ['url' => '', 'title' => trans('agendamento.list', ['page' => $page])],
        ];

        return view('admin.' . $routeName . '.index', ['list' => $list, 'search' => $search,
            'page' => $page, 'routeName' => $routeName, 'columnList' => $columnList, 'breadcrumb' => $breadcrumb]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $routeName = $this->route;
        $page = trans('agendamento.agendamento_list');
        $page_create = trans('agendamento.agendamento');

        $breadcrumb = [
            (object) ['url' => route('home'), 'title' => trans('agendamento.home')],
            (object) ['url' => route($routeName . '.index'), 'title' => trans('agendamento.list', ['page' => $page])],
            (object) ['url' => '', 'title' => trans('agendamento.create_crud', ['page' => $page_create])],
        ];

        return view('admin.' . $routeName . '.create', ['page' => $page, 'page_create' => $page_create, 'routeName' => $routeName, 'breadcrumb' => $breadcrumb]);

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();

        FacadesValidator::make($data, [
            'municipio' => 'required|string|max:255',
            'name' => 'required|string|max:255',
            'cpf' => 'required|string|min:11',
            'titulo' => 'required|string',
            'telefone' => 'required|string|min:11',
            'nome_mae' => 'required|string',
            'data_nascimento' => 'required',
            'escritorio' => 'required',
        ]);

        if ($this->model->create($data)) {
            session()->flash('msg', trans('agendamento.record_added_successfully'));
            session()->flash('status', 'success'); // success error notification
            return redirect()->back();
        } else {
            session()->flash('msg', trans('agendamento.error_adding_registry'));
            session()->flash('status', 'error'); // success error notification
            return redirect()->back();
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id, Request $request)
    {
        $routeName = $this->route;

        $register = $this->model->find($id);

        if ($register) {
            $page = trans('agendamento.agendamento_list');
            $page2 = trans('agendamento.agendamento');

            $breadcrumb = [
                (object) ['url' => route('home'), 'title' => trans('agendamento.home')],
                (object) ['url' => route($routeName . '.index'), 'title' => trans('agendamento.list', ['page' => $page])],
                (object) ['url' => '', 'title' => trans('agendamento.show_crud', ['page' => $page2])],
            ];
            $delete = false;
            if ($request->delete ?? false) {
                session()->flash('msg', trans('agendamento.delete_this_record'));
                session()->flash('status', 'notification'); // success error notification
                $delete = true;
            }

            return view('admin.' . $routeName . '.show', ['page' => $page, 'delete' => $delete, 'page2' => $page2, 'register' => $register, 'routeName' => $routeName, 'breadcrumb' => $breadcrumb]);
        }
        return redirect()->route($routeName . '.index');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $routeName = $this->route;

        $register = $this->model->find($id);

        if ($register) {
            $page = trans('agendamento.agendamento_list');
            $page2 = trans('agendamento.agendamento');

            $breadcrumb = [
                (object) ['url' => route('home'), 'title' => trans('agendamento.home')],
                (object) ['url' => route($routeName . '.index'), 'title' => trans('agendamento.list', ['page' => $page])],
                (object) ['url' => '', 'title' => trans('agendamento.edit_crud', ['page' => $page2])],
            ];

            return view('admin.' . $routeName . '.edit', ['page' => $page, 'page2' => $page2, 'register' => $register, 'routeName' => $routeName, 'breadcrumb' => $breadcrumb]);
        }
        return redirect()->route($routeName . '.index');

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->all();

        if (!$data['password']) {
            unset($data['password']);
        }

        FacadesValidator::make($data, [
            'municipio' => 'required|string|max:255',
            'name' => 'required|string|max:255',
            'cpf' => 'required|string|min:11',
            'titulo' => 'required|string',
            'telefone' => 'required|string|min:11',
            'nome_mae' => 'required|string',
            'data_nascimento' => 'required',
            'escritorio' => 'required',
        ]);

        if ($this->model->update($data, $id)) {
            session()->flash('msg', trans('agendamento.successfully_edited_record'));
            session()->flash('status', 'success'); // success error notification
            return redirect()->back();
        } else {
            session()->flash('msg', trans('agendamento.error_editing_record'));
            session()->flash('status', 'error'); // success error notification
            return redirect()->back();
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if ($this->model->delete($id)) {
            session()->flash('msg', trans('agendamento.registration_deleted_successfully'));
            session()->flash('status', 'error'); // success error notification
        } else {
            session()->flash('msg', trans('agendamento.error_deleting_record'));
            session()->flash('status', 'error'); // success error notification
        }

        $routeName = $this->route;
        return redirect()->route($routeName . '.index');
    }

    

}
