<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Repositories\Contracts\PermissionRepositoryInterface;
use Illuminate\Http\Request;
use Validator;


class PermissionController extends Controller
{
    private $route = 'permissions';
    private $paginate = 10;
    private $search = ['name', 'description'];
    private $model;

    public function __construct(PermissionRepositoryInterface $model)
    {
        $this->model = $model;
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $columnList = ['id' => '#', 'name' => trans('agendamento.name'), 'description' => trans('agendamento.description')];
        $page = trans('agendamento.permission_list');

        $search = "";
        if (isset($request->search)) {
            $search = $request->search;
            $list = $this->model->findWhereLike($this->search, $search, 'id', 'DESC');
        } else {
            $list = $this->model->paginate($this->paginate);
        }

        $routeName = $this->route;

        //$request->session()->flash('msg', 'Olá Alert');
        //$request->session()->flash('status', 'success'); // success error notification

        $breadcrumb = [
            (object) ['url' => route('home'), 'title' => trans('agendamento.home')],
            (object) ['url' => '', 'title' => trans('agendamento.list', ['page' => $page])],
        ];

        return view('admin.' . $routeName . '.index', ['list' => $list, 'search' => $search,
            'page' => $page, 'routeName' => $routeName, 'columnList' => $columnList, 'breadcrumb' => $breadcrumb]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $routeName = $this->route;
        $page = trans('agendamento.permission_list');
        $page_create = trans('agendamento.permission');

        $breadcrumb = [
            (object) ['url' => route('home'), 'title' => trans('agendamento.home')],
            (object) ['url' => route($routeName . '.index'), 'title' => trans('agendamento.list', ['page' => $page])],
            (object) ['url' => '', 'title' => trans('agendamento.create_crud', ['page' => $page_create])],
        ];

        return view('admin.' . $routeName . '.create', ['page' => $page, 'page_create' => $page_create, 'routeName' => $routeName, 'breadcrumb' => $breadcrumb]);

    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data = $request->all();

        Validator::make($data, [
            'name' => 'required|string|max:255',
            'description' => 'required|string|max:300',
        ])->validate();

        if ($this->model->create($data)) {
            session()->flash('msg', trans('agendamento.record_added_successfully'));
            session()->flash('status', 'success'); // success error notification
            return redirect()->back();
        } else {
            session()->flash('msg', trans('agendamento.error_adding_registry'));
            session()->flash('status', 'error'); // success error notification
            return redirect()->back();
        }

    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id, Request $request)
    {
        $routeName = $this->route;

        $register = $this->model->find($id);

        if ($register) {
            $page = trans('agendamento.permission_list');
            $page2 = trans('agendamento.permission');

            $breadcrumb = [
                (object) ['url' => route('home'), 'title' => trans('agendamento.home')],
                (object) ['url' => route($routeName . '.index'), 'title' => trans('agendamento.list', ['page' => $page])],
                (object) ['url' => '', 'title' => trans('agendamento.show_crud', ['page' => $page2])],
            ];
            $delete = false;
            if($request->delete ?? false){
                session()->flash('msg', trans('agendamento.delete_this_record'));
                session()->flash('status', 'notification'); // success error notification
                $delete = true;
            }

            return view('admin.' . $routeName . '.show', ['page' => $page, 'delete' => $delete, 'page2' => $page2,'register' => $register, 'routeName' => $routeName, 'breadcrumb' => $breadcrumb]);
        }
        return redirect()->route($routeName.'.index');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $routeName = $this->route;

        $register = $this->model->find($id);

        if ($register) {
            $page = trans('agendamento.permission_list');
            $page2 = trans('agendamento.permission');

            $breadcrumb = [
                (object) ['url' => route('home'), 'title' => trans('agendamento.home')],
                (object) ['url' => route($routeName . '.index'), 'title' => trans('agendamento.list', ['page' => $page])],
                (object) ['url' => '', 'title' => trans('agendamento.edit_crud', ['page' => $page2])],
            ];

            return view('admin.' . $routeName . '.edit', ['page' => $page, 'page2' => $page2, 'register' => $register, 'routeName' => $routeName, 'breadcrumb' => $breadcrumb]);
        }
        return redirect()->route($routeName.'.index');

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $data = $request->all();

        Validator::make($data, [
            'name' => 'required|string|max:255',
            'description' => 'required|string|max:300',
        ])->validate();

        if ($this->model->update($data, $id)) {
            session()->flash('msg', trans('agendamento.successfully_edited_record'));
            session()->flash('status', 'success'); // success error notification
            return redirect()->back();
        } else {
            session()->flash('msg', trans('agendamento.error_editing_record'));
            session()->flash('status', 'error'); // success error notification
            return redirect()->back();
        }
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        if($this->model->delete($id)){
            session()->flash('msg', trans('agendamento.registration_deleted_successfully'));
            session()->flash('status', 'success'); // success error notification
        }else{
            session()->flash('msg', trans('agendamento.error_deleting_record'));
            session()->flash('status', 'error'); // success error notification
        }

        $routeName = $this->route;
        return redirect()->route($routeName.'.index');
    }
}
