<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Lote extends Model
{
    protected $table = 'sige.lotes';
    // protected $fillable = ['id', 'area', 'ativo', 'criado_por_id', 'dhc', 'dhm', 'modificado_por_id',
    //     'municipio_id', 'nome', 'numero', 'perimetro', 'proprietario', 'situacao_juridica_id',
    //     'titulo', 'sncr', 'cpf', 'protocolo', 'is_aprovado', 'data_termino_periodo_de_uso',
    //     'status_estrutura', 'status_pessoa', 'status_uso', 'comunidade', 'localidade', 'projeto_especial',
    //     'cnpj', 'status_titulo', 'migrado_para_access', 'cod_imo_rur'];

    // public function titulos(){
    //     return $this->hasMany(Titulo::class, 'lote_id', 'id');
    // }

    // public function secUser(){
    //     return $this->belongsTo(SecUser::class);
    // }
 
    public function municipio()
    {
        return $this->belongsTo(Municipio::class);
    }

    public function processos()
    {
        //lote_id: na tabela Processos, id: na tabela Lotes
        return $this->hasMany(Processo::class, 'lote_id', 'id');
    }

    public function situacaoJuridica()
    {
        return $this->belongsTo(SituacaoJuridica::class);
    }

    public function pessoaLote()
    {
        //lote_id: na tabela PessoaLote, id: na tabela Lotes
        return $this->hasMany(PessoaLote::class, 'lote_id', 'id');
    }

    public function formasObtencao()
    {
        return $this->hasMany(FormaObtencao::class, 'lote_id', 'id');
    }

    public function lotesTramites()
    {
        return $this->hasMany(LoteTramite::class, 'lote_id', 'id');
    }

    
}
